#!/system/bin/sh

##get highest priority
/system/bin/renice -20 -r -g $$

ECHO_TARGET=/misc/inandop.log
#ECHO_TARGET=/dev/null
PAT=mmcblk3
PAT_SDCARD=mmcblk3p1
PAT_DATA=mmcblk3p2
PAT_MAX=mmcblk3p2
PAT_MIN=mmcblk3p1


echo " " >> $ECHO_TARGET
echo "now start inandop.sh " >> $ECHO_TARGET
#ls -l /dev/block/mmcblk3p2 >> $ECHO_TARGET
ls -l /dev/block/$PAT_MAX
resultp1=$?
ls -l /dev/block/$PAT_MIN
resultp2=$?
result=0
case "$resultp1" in
0)
;;
*)
result=1
;;
esac

case "$resultp2" in
0)
;;
*)
result=1
;;
esac

echo "ls result=$result" >> $ECHO_TARGET
#check if it's already divided into two partitions
breset=0
case "$result" in
0)
echo "equal or more than two paritions" >> $ECHO_TARGET

echo "check if need to reformat" >> $ECHO_TARGET
	/system/bin/mount -t ext3 /dev/block/$PAT_DATA /mnt/sdcard
	result=$?
	echo "mount PAT_DATA result=$result" >> $ECHO_TARGET
	
	case "$result" in
	0)
		/system/bin/umount /mnt/sdcard 
		result=$?
		echo "umount PAT_DATA result=$result" >> $ECHO_TARGET
		;;
	*)
		/system/bin/sleep 0
		/system/bin/mount -t ext3 /dev/block/$PAT_DATA /mnt/sdcard
		result=$?
		echo "mount PAT_DATA result=$result" >> $ECHO_TARGET
		case "$result" in
		0)
			/system/bin/umount /mnt/sdcard 
			result=$?
			echo "umount PAT_DATA result=$result" >> $ECHO_TARGET
			;;
		*)
			breset=1
			/system/bin/sleep 0
			/system/bin/busybox mkfs.ext3 -b 2048 /dev/block/$PAT_DATA
			result=$?
			echo "format PAT_DATA result=$result" >> $ECHO_TARGET
			case "$result" in
			0)
				;;
			*)
				/system/bin/sleep 0
				/system/bin/busybox mkfs.ext3 -b 2048 /dev/block/$PAT_DATA
				result=$?
				echo "format PAT_DATA result=$result" >> $ECHO_TARGET
			;;
			esac
			case "$result" in
			0)
				;;
			*)
				/system/bin/sleep 0
				/system/bin/busybox mkfs.ext3 -b 2048 /dev/block/$PAT_DATA
				result=$?
				echo "format PAT_DATA result=$result" >> $ECHO_TARGET
			;;
			esac
		;;
		esac
		;;
	esac
	;;
*)
	echo "less than two paritions" >> $ECHO_TARGET
	breset=1
	# Firstly destroy the partition to avoid mounting to /sdcard
	/system/bin/dd if=/dev/zero of=/dev/block/$PAT bs=1024 count=1  
	result=$?
	/system/bin/sleep 1
	echo "avoid mounting to sdcard result=$result" >> $ECHO_TARGET
	case "$result" in
	0)
		;;
	*)
		/system/bin/dd if=/dev/zero of=/dev/block/$PAT_SDCARD bs=512 count=1  
		result=$?
		echo "avoid mounting to sdcard result=$result" >> $ECHO_TARGET
		;;
	esac
	
	# divide disk into two partitions
	/system/bin/busybox fdisk /dev/block/$PAT 
	result=$?
	echo "divide to two partitions result=$result" >> $ECHO_TARGET
	case "$result" in
	0)
		;;
	*)
		/system/bin/sleep 0
		/system/bin/busybox fdisk /dev/block/$PAT
		result=$?
		echo "divide to two partitions result=$result" >> $ECHO_TARGET
		;;
	esac
	case "$result" in
	0)
		;;
	*)
		/system/bin/sleep 0
		/system/bin/busybox fdisk /dev/block/$PAT
		result=$?
		echo "divide to two partitions result=$result" >> $ECHO_TARGET
		;;
	esac
	
	# The second partition is for /data (2G/8G or 2G/16G)
	/system/bin/busybox mkfs.ext3 -b 2048 /dev/block/$PAT_DATA
	result=$?
	echo "format PAT_DATA result=$result" >> $ECHO_TARGET
	case "$result" in
	0)
		;;
	*)
		/system/bin/sleep 0
		/system/bin/busybox fdisk /dev/block/$PAT_DATA
		result=$?
		echo "format PAT_DATA result=$result" >> $ECHO_TARGET
		;;
	esac
	case "$result" in
	0)
		;;
	*)
		/system/bin/sleep 0
		/system/bin/busybox fdisk /dev/block/$PAT_DATA
		result=$?
		echo "format PAT_DATA result=$result" >> $ECHO_TARGET
		;;
	esac

	# The first partition is for /sdcard (6G/8G or 14G/16G)
	/system/bin/newfs_msdos -F 32 -O Android -c 8 /dev/block/$PAT_SDCARD
	result=$?
	echo "format PAT_SDCARD result=$result" >> $ECHO_TARGET
	case "$result" in
	0)
		;;
	*)
		/system/bin/sleep 0
		/system/bin/newfs_msdos -F 32 -O Android -c 8 /dev/block/$PAT_SDCARD
		result=$?
		echo "format PAT_SDCARD result=$result" >> $ECHO_TARGET
		;;
	esac
	case "$result" in
	0)
		;;
	*)
		/system/bin/sleep 0
		/system/bin/newfs_msdos -F 32 -O Android -c 8 /dev/block/$PAT_SDCARD
		result=$?
		echo "format PAT_SDCARD result=$result" >> $ECHO_TARGET
		;;
	esac
	;;
esac

case "$breset" in
0)
	;;
*)
	/system/bin/sleep 3
	/system/bin/reboot
	;;
esac

exit 0


